{
Copyright (C) 2012 Ruslan Neborak

 This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

   1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

   2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

   3. This notice may not be removed or altered from any source
   distribution.
}
//FlyLogReader v. 0.0.2
//Read *.r file (AEO APACHE OSD), draw charts and save data to ods/excel xml spreadsheet format.
//Last update: 2012.05.30

unit unit_main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, Menus, zexmlss, TAGraph, TASeries,
  osdroutines, TAChartUtils, TALegendPanel, types, TACustomSeries;

type
  { TfrmMain }
  TfrmMain = class(TForm)
    btnLoad: TButton;
    btnSave: TButton;
    btnSaveKml: TButton;
    CharLegend: TChartLegendPanel;
    CBGShowChart: TCheckGroup;
    FlyChart: TChart;
    mnuSaveKML: TMenuItem;
    mnuAbout: TMenuItem;
    mnuHelp: TMenuItem;
    SDKML: TSaveDialog;
    SerLine: TConstantLine;
    LabelMSG: TLabel;
    LabelHint: TLabel;
    MainMenu: TMainMenu;
    mnuSaveXMLSS: TMenuItem;
    MenuItem2: TMenuItem;
    mnuClose: TMenuItem;
    mnuLoadR: TMenuItem;
    mnuFile: TMenuItem;
    PanelLog: TPanel;
    PanelBTN: TPanel;
    SerMSL_Altitude: TLineSeries;
    SerSysBatVideo: TLineSeries;
    SerTemperature: TLineSeries;
    SerSpeed: TLineSeries;
    SerSysBatCur: TLineSeries;
    SerSysBatVol: TLineSeries;
    MemoLog: TMemo;
    ODR: TOpenDialog;
    PanelRight: TPanel;
    SDXML: TSaveDialog;
    ZEXML: TZEXMLSS;
    procedure btnLoadClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure btnSaveKmlClick(Sender: TObject);
    procedure CBGShowChartItemClick(Sender: TObject; Index: integer);
    procedure FlyChartMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer
      );
    procedure FormCreate(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure mnuCloseClick(Sender: TObject);
    procedure mnuLoadRClick(Sender: TObject);
    procedure mnuSaveKMLClick(Sender: TObject);
    procedure mnuSaveXMLSSClick(Sender: TObject);
  private
    { private declarations }
    FOldMouseX: integer;
    FOldMouseY: integer;
    FIsLoaded: boolean;
    procedure SetLoaded(Value: boolean);
  public
    { public declarations }
    procedure LoadRFile();
    procedure SaveXMLSSFile();
    procedure SaveKML();
    property IsLoaded: boolean read FIsLoaded write SetLoaded;
  end; 

var
  frmMain: TfrmMain;

implementation

uses
  unit_about;

{$R *.lfm}

{ TfrmMain }

procedure TfrmMain.SetLoaded(Value: boolean);
begin
  FIsLoaded := Value;
  btnSave.Enabled := Value;
  mnuSaveXMLSS.Enabled := Value;
  btnSaveKml.Enabled := Value;
  mnuSaveKML.Enabled := Value;
end;

procedure TfrmMain.LoadRFile();
var
  FlyArray: TFlyOSDArray;
  CNT: integer;
  FlyHeader: TFlyOSDHeader;
  RVer: integer;
  i: integer;
  temp: real;
  num: real;
  ret: byte;

begin
  CNT := 0;
  RVer := 0;
  ret := 0;
  SetLength(FlyArray, 0);
  if (ODR.Execute) then
  begin
    try
      isLoaded := false;
      ret := ReadFlyOSDR(ODR.FileName, FlyArray, CNT, FlyHeader, RVer, MemoLog);
      if (ret <> 0) then
        MemoLog.Lines.Add('Warning: return code=' + IntToStr(ret));

      SerSysBatVol.Clear();
      SerSysBatVol.Clear();
      SerTemperature.Clear();
      SerSysBatCur.Clear();
      SerSysBatVideo.Clear();
      SerMSL_Altitude.Clear();
      SerSpeed.Clear();

      for i := 0 to CNT - 1 do
      begin
        num := i / 2;
        SerSysBatCur.AddXY(num, FlyArray[i].SYSBatCur / 10);
        SerSysBatVol.AddXY(num, FlyArray[i].SYSBatVol / 10);
        SerSpeed.AddXY(num, FlyArray[i].Speed / 10);
        if (FlyArray[i].Temperature > 200) then
          temp := real(FlyArray[i].Temperature) - 255
        else
          temp := FlyArray[i].Temperature;
        SerTemperature.AddXY(num, temp);
        SerSysBatVideo.AddXY(num, FlyArray[i].SYSBatVideo / 10);
        SerMSL_Altitude.AddXY(num, FlyArray[i].MSL_Altitude / 10);
      end;
      ArrayToXMLSS(FlyArray, CNT, FlyHeader, RVer, ZEXML, ODR.FileName);
      if (CNT > 1) then
        IsLoaded := true;
    except
      on E: Exception do
      begin
        if (CNT <= 1) then
          IsLoaded := false;
        MemoLog.Lines.Add('ReadFile error: ' + E.Message);
      end;
    end;
  end;
  SetLength(FlyArray, 0);
  FlyArray := nil;
end;

procedure TfrmMain.SaveKML();
begin
  try
    if (IsLoaded) then
      if (SDKML.Execute) then
        SaveToKML(SDKML.FileName, ZEXML, nil);
  except
    on E: Exception do
      MemoLog.Lines.Add('KML error: ' + E.Message);
  end;
end;

procedure TfrmMain.SaveXMLSSFile();
var
  s: string;
  l: integer;
  _format: integer;

begin
  try
    if (IsLoaded) then
    begin
      SDXML.FileName := '';
      SDXML.Files.Clear();
      if (SDXML.Execute) then
      begin
        s := '';
        l := length(SDXML.FileName);
        s := copy(SDXML.FileName, l - 3, 4);
        s := UpperCase(s);
        if (length(s) > 0) then
        begin
          if (s[1] <> '.') then
          case SDXML.FilterIndex of
            1:
              begin
                s := '.ODS';
                SDXML.FileName := SDXML.FileName + '.ods';
              end;
            2:
              begin
                s := '.XML';
                SDXML.FileName := SDXML.FileName + '.xml';
              end;
          end;
        end;
        _format := 0;
        if (s = '.ODS') then
          _format := 1;
        if (s = '.XML') then
          _format := 0;
        SaveToXmlSS(SDXML.FileName, ZEXML, _format);
      end;
    end;
  except
    on E: Exception do
      MemoLog.Lines.Add('Write error: ' + E.Message);
  end;
end;

procedure TfrmMain.btnLoadClick(Sender: TObject);
begin
  LoadRFile();
end;

procedure TfrmMain.btnSaveClick(Sender: TObject);
begin
  SaveXMLSSFile();
end;

procedure TfrmMain.btnSaveKmlClick(Sender: TObject);
begin
  SaveKML();
end;

procedure TfrmMain.CBGShowChartItemClick(Sender: TObject; Index: integer);
var
  b: boolean;

begin
  b := CBGShowChart.Checked[Index];
  case (Index) of
    0: SerMSL_Altitude.Active := b;
    1: SerSpeed.Active := b;
    2: SerSysBatVol.Active := b;
    3: SerSysBatCur.Active := b;
    4: SerSysBatVideo.Active := b;
    5: SerTemperature.Active := b;
  end;
end;

procedure TfrmMain.FlyChartMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  MP, p1: TPoint;
  i: integer;
  t: TDoublePoint;
  k: integer;
  Serie: TLineSeries;
  s: string;

begin
  if (IsLoaded) then
  if (FOldMouseX <> X) then
  begin
    MP.x := X;
    MP.y := Y;

    s := '';
    for k := 0 to FlyChart.SeriesCount - 1 do
    begin
       Serie := nil;
       if (FlyChart.Series[k] is TLineSeries) then
         Serie := FlyChart.Series[k] as TLineSeries;
       if (Assigned(Serie)) then
       if (Serie.Active) then
       begin
         Serie.GetNearestPoint(@PointDistX, MP, i, p1, t);
         s := s + ' ' +  Serie.Title + '=' + FloatToStr(t.Y) + LineEnding;
       end;
    end; //for k

    LabelHint.Caption := s;

    FlyChart.Hint := s;
    Application.CancelHint;
    Application.ActivateHint(MP, true);
    SerLine.Position := t.X;

    FOldMouseX := X;
    FOldMouseY := Y;
  end;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  FIsLoaded := false;
end;

procedure TfrmMain.mnuAboutClick(Sender: TObject);
begin
  with TfrmAbout.Create(self) do
  try
    ShowModal();
  finally
    free;
  end;
end;

procedure TfrmMain.mnuCloseClick(Sender: TObject);
begin
  Close();
end;

procedure TfrmMain.mnuLoadRClick(Sender: TObject);
begin
  LoadRFile();
end;

procedure TfrmMain.mnuSaveKMLClick(Sender: TObject);
begin
  SaveKML();
end;

procedure TfrmMain.mnuSaveXMLSSClick(Sender: TObject);
begin
  SaveXMLSSFile();
end;

end.

